/************************************************************************\
	Convert "Content-Transfer-Encoding: quoted-printable"
\************************************************************************/


#include "objects.h"
#include "NewtonScript.h"


// Single character decode
#define	DEC(Char) (((Char) - ' ') & 0x3F)


static long _unquote ( void * srcUnicodeP, void * destBinP );

extern "C" Ref UnQuote ( RefArg rcvr, RefArg srcUnicode, RefArg destBinObj )
{
	if ( !IsString(srcUnicode) )
		ThrowBadTypeWithFrameData ( -48402, srcUnicode );	// expected a string

	if ( !IsBinary(destBinObj) )
		ThrowBadTypeWithFrameData ( -48408, destBinObj );	// expected a binary object

	long	resultLength;

	WITH_LOCKED_BINARY ( srcUnicode, srcP )
	WITH_LOCKED_BINARY ( destBinObj, destP )

		resultLength = _uudecodeStd ( srcP, destP );

	END_WITH_LOCKED_BINARY(srcUnicode)
	END_WITH_LOCKED_BINARY(destBinObj)

	return MakeInt ( resultLength );
}


long _uudecodeStd ( void * srcUnicodeP, void * destBinP )
{
	short	* p       = (short *)srcUnicodeP;
	char	* resultP = (char *)destBinP;

	while (1)
	{
		long		n;

		// N is used to avoid writing out all the
		// characters at the end of the file.

		while ( *p == 13 )
			p++;

		if ( *p == 0 )	// end of text with no "end" marker
			break;

		if ( p[0] == 'e' && p[1] == 'n' && p[2] == 'd' && p[3] == 13 )
			break;

		n = DEC (*p);

		if ( n <= 0 )
		{
			break;
		}

		for ( ++p; n > 0; p += 4, n -= 3 )
		{
			char ch;

			if (n >= 3)
			{
				ch = DEC (p[0]) << 2 | DEC (p[1]) >> 4;
				*resultP++ = ch;

				ch = DEC (p[1]) << 4 | DEC (p[2]) >> 2;
				*resultP++ = ch;

				ch = DEC (p[2]) << 6 | DEC (p[3]);
				*resultP++ = ch;
			}
			else
			{
				if (n >= 1)
				{
					ch = DEC (p[0]) << 2 | DEC (p[1]) >> 4;
					*resultP++ = ch;
				}
				if (n >= 2)
				{
					ch = DEC (p[1]) << 4 | DEC (p[2]) >> 2;
					*resultP++ = ch;
				}
			}
		}
	}

	long size = (long)resultP - (long)destBinP;

	return size;
}
